/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	RainLift
**
** DESCRIPTION:	Rain lift construction puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef RAINLIFT_H
#define RAINLIFT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "Puzzle.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int RainLift_c_iLiftImageColumns = 4;
const int RainLift_c_iLiftImageRows = 2;
const int RainLift_c_iLiftFrames = RainLift_c_iLiftImageColumns * RainLift_c_iLiftImageRows;
const ldwPoint RainLift_c_sLiftPos = ldwPoint(1477, 845);
const ldwPoint RainLift_c_sBrokenLiftPos = ldwPoint(1520, 824);
const ldwPoint RainLift_c_sLiftPlatformBase = ldwPoint(1657, 966);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CRainLift : public IPuzzle
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_Lift = ePuzzle_RainLift + (1 << 16),
		eRef_BrokenLift = ePuzzle_RainLift + (2 << 16)
	};

	//class structures
	struct SSaveState
	{
		int		m_iCurrentLiftFrame;
		int		m_iPreviousLiftFrame;
		int		m_iVillagerOnLift;
	};

	//class data
	ldwImageGrid *	m_pLiftImage;
	ldwImage *		m_pBrokenLiftImage;

	int				m_iCurrentLiftFrame;
	int				m_iPreviousLiftFrame;

	int				m_iVillagerOnLift;

	//class methods
	//setup
	public:		CRainLift(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;
	public:		void Complete();

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);

	// access
	public:		const bool IsRepaired() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CRainLift		RainLift;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/